VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "PScript"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' Declarations
Private scVBScript As MSScriptControl
Private scJScript As MSScriptControl
Private ScriptSupportClass As New PPluginInterface

' Properties
Public Property Get VBScriptControl()
  Set VBScriptControl = scVBScript
End Property
Public Property Set VBScriptControl(value As ScriptControl)
  Set scVBScript = value
End Property
Public Property Get JScriptControl()
  Set JScriptControl = scJScript
End Property
Public Property Set JScriptControl(value As ScriptControl)
  Set scJScript = value
End Property

' Must be called before doing anything else with the Scripting class
Public Sub Initialize()
  ' Insure we have the correct languages
  scJScript.Language = "JScript"
  scVBScript.Langauge = "VBScript"
  ' Add our ScriptSupportClass
  Call scJScript.AddObject("SSC", ScriptSupportClass, True)
  Call scVBScript.AddObject("SSC", ScriptSupportClass, True)
End Sub

' Load a script
' Code (String)
'  - The source code of the script file
' File (String)
'  - The full path to the script file
' Language (String)
'  - JScript or VBScript, the language the script file is programmed in
Public Function LoadScript(Code As String, File As String, Language As String)
  On Error GoTo HandleSyntaxError
  ' Get the script control to use
  If Language = "JScript" Then
    scUse = scJScript
  ElseIf Language = "VBScript" Then
    scUse = scVBScript
  End If
  ' Add a module to the script control
  Set scModule = scUse.Modules.Add(scUse.Modules.Count() + 1)
  ' Return the index of the script
  LoadScript = scUse.Modules.Count()
  ' Add the code to the script control
  Call scModule.AddCode(Code)
  
HandleSyntaxError:
  If Err Then
    ' It has an error, report it
    With scModule.Error
      ' I didn't output this, but here are the properties you can use
      .Number
      .Description
      .Line
      .Column
      .Text
    End With
  End If
End Function

' Call an event throughout all of the scripts loaded
' Procedure (String)
' - The Procedure to call
' Args (Variant)
' - A ParamArray of arguments to add to the procedure
Public Sub CallProcedure(Procedure As String, ParamArray Args() As Variant)
  For I = 1 To scJScript.Modules.Count()
    Call CallScriptProcedure(Procedure, I, "JScript", Args)
  Next
  For I = 1 To scVBScript.Modules.Count()
    Call CallScriptProcedure(Procedure, I, "VBScript", Args)
  Next
End Sub

' Call an Procedure in a specific script
' Procedure (String)
' - The Procedure to call
' Index (Integer)
' - The index of the script in the control
' Language (String)
' - JScript or VBScript, the language the script file is programmed in
Public Sub CallScriptProcedure(Procedure As String, Index As Integer, Language As String, Args() As Variant)
  Dim strArgs As String
  ' Get the script control to use
  If Language = "JScript" Then
    scUse = scJScript
  ElseIf Language = "VBScript" Then
    scUse = scVBScript
  End If
  ' Get the module containing the script
  scModule = scUse.Modules.Item(Index)
  ' Loop through the procedures checking if the Procedure exists
  Found = False
  For Each scProcedure In scModule.Procedures()
    If LCase(scProcedure.Name) = LCase(Procedure) Then
      ' The procedure was found, call it with the array of args
      ' This is where I begin to have problems :o
      
      For I = 0 To UBound(Args)
        If I = 0 Then
          strArgs = Args(I)
        Else
          strArgs = ", " & Args(I)
        End If
      Next
      ' Not quite sure if you can use the Execute statement in VB6
      Call scModule.Run(scProcedure.Name, strArgs & ")")
      Exit For
      
    End If
  Next
End Sub

